class TriggerTokenMapper:
    """
    Stage 3: Map generic tokens to trigger tokens using Gemini.
    """
    
    def __init__(self, model_name: str = "gemini-2.5-flash-exp"):
        """Initialize Gemini for token mapping."""
        genai.configure(api_key="YOUR_GEMINI_API_KEY")
        self.model = genai.GenerativeModel(model_name)
    
    def map_prompt_tokens(
        self,
        prompt: str,
        selected_checkpoint: Checkpoint
    ) -> str:
        """
        Replace generic nouns with checkpoint-specific trigger tokens.
        """
        mapping_prompt = f"""Map the generic nouns in the user prompt to the checkpoint's trigger tokens.
        
        User prompt: {prompt}
        
        Checkpoint information:
        - Subject types: {selected_checkpoint.subject_types}
        - Trigger tokens: {selected_checkpoint.trigger_tokens}
        - Description: {selected_checkpoint.description}
        
        Instructions:
        1. Identify any generic noun in the prompt that matches the subject types
        2. Replace it with the appropriate trigger token
        3. Handle morphological variations (e.g., "bears" -> trigger token for "bear")
        4. Preserve the rest of the prompt exactly
        5. If multiple subject words exist, replace the most prominent one
        
        Example:
        Input: "A cute bear sitting in the forest"
        Subject types: ["bear", "teddy bear"]
        Trigger tokens: ["<bear-v4>"]
        Output: "A cute <bear-v4> sitting in the forest"
        
        Return ONLY the modified prompt, nothing else."""
        
        response = self.model.generate_content(mapping_prompt)
        mapped_prompt = response.text.strip()
        
        # Validate that trigger tokens are actually used
        trigger_found = any(token in mapped_prompt for token in selected_checkpoint.trigger_tokens)
        if not trigger_found:
            print(f"Warning: No trigger tokens found in mapped prompt: {mapped_prompt}")
        
        return mapped_prompt
